<?php

function image_upload_form_handler()
{
	global $db, $smarty, $image;

	include_once('image_upload_settings.php');
	$smarty->plugins_dir[] = image_upload_plugins_path;
	
	$main_smarty->display(image_upload_tpl_path . 'submission_form_addition.tpl');
}

function image_upload_process_handler($imageData)
{
	global $db, $smarty, $main_smarty, $linkres;

	include_once('image_upload_settings.php');
	include_once(mnmmodules . 'image_upload/plugins/class.thumbnail.inc.php');
	include_once(mnmmodules . 'image_upload/plugins/class.imageconverter.inc.php');
	
	$smarty->plugins_dir[] = image_upload_plugins_path;

	// Get the image real name, temp name, submission ID	
	$imageFilename = $_FILES[module_imageupload_filename_field]['name'];
	$sourceFile = $_FILES[module_imageupload_filename_field]['tmp_name'];
	$linkID = $_POST['id'];

	// Get new names
	$destFile = module_imageupload_fullsize_prefix.$linkID;
	$destPath = module_imageupload_basedir.module_imageupload_imagedir;

	// Get image dimensions
	$thisImage = getimagesize($sourceFile);
	$thisImageWidth = $thisImage[0];
	$thisImageHeight = $thisImage[1];
	$thisImageMimeType = $thisImage['mime'];
		
	$module_error = true;
	
	// Determine Mime Type
	switch ($thisImageMimeType)
	{
		case "image/jpeg":
			$module_error = false;
			$tempExt = ".jpg";
			break;
			
		case "image/gif":
			$module_error = false;
			$tempExt = ".gif";
			break;
			
		case "image/png":
			$module_error = false;
			$tempExt = ".png";
			break;
			
		case "image/wbmp":
			$module_error = false;
			$tempExt = ".wbmp";
			break;
			
		default:
			$module_error = true;
			$module_error_message = module_imageupload_errorcode_1;
			@unlink($sourceFile);
	}

	if (module_imageupload_debugmode)
	{
		echo "<b>Processing image upload</b><br/>";
		echo "Link ID........: ".$linkID."<br/>";
		echo "Image Name.....: ".$imageFilename."<br/>";
		echo "Temp Filename..: ".$sourceFile."<br/>";
		echo "Dest File......: ".$destFile.$tempExt."<br/>";
		echo "Dest Path......: ".$destPath."<br/>";
		echo "Image Width....: ".$thisImageWidth."<br/>";
		echo "Image Height...: ".$thisImageHeight."<br/>";
		echo "Image Mime Type: ".$thisImageMimeType."<br/>";
	}

	// Process file, remove re-posts, and convert if necessary
	if (!$module_error)
	{
		if (file_exists($destPath.$destFile.$tempExt))
		{
			@unlink($destPath.$destFile.$tempExt);
		}
		
		// Convert image if not JPG
		switch ($thisImageMimeType)
		{
			case "image/jpeg":
				// No conversion needed
				if(!move_uploaded_file($sourceFile, $destPath.$destFile.$tempExt))
				{
					$module_error = true;
					$module_error_message = module_imageupload_errorcode_2; 
					// Delete original
					@unlink($destPath.$destFile.$tempExt);
				}
				break;
				
			case "image/gif":
			case "image/png":
			case "image/wbmp":
				if(move_uploaded_file($sourceFile, $destPath.$destFile.$tempExt))
				{
					$tempDest = $destPath.$destFile.$tempExt;
					
					// Convert image to JPG
					$img = new ImageConverter($tempDest, "jpg", $destPath);
					@unlink($tempDest);
					
					if (module_imageupload_debugmode)
					{
						// Get converted image dimensions
						$destImage = getimagesize($destPath.$destFile.".jpg");
						$destImageWidth = $destImage[0];
						$destImageHeight = $destImage[1];
						$destImageMimeType = $destImage['mime'];
						echo "<b>Converting image</b><br/>";
						echo "Dest Filename...........: ".$destPath.$destFile.".jpg<br/>";
						echo "Dest Image Width........: ".$destImageWidth."<br/>";
						echo "Dest Image Height.......: ".$destImageHeight."<br/>";
						echo "Dest Image Mime Type....: ".$destImageMimeType."<br/>";
					}
				} else {
					$module_error = true;
					$module_error_message = module_imageupload_errorcode_2; 
					// Delete original
					@unlink($sourceFile);
				}
				break;
		}
	}
		
	// Check if we need to resize image to meet fullsize width or height setting
	if (!$module_error)
	{
		# Check to see if the image needs to be rescaled.
		switch (module_imageupload_fullsize_maxtoggle)
		{
			case "w":
				if ($thisImageWidth > module_imageupload_fullsize_width)
				{
					$newimage = new thumbnail($destPath.$destFile);
					$newimage->size_auto(module_imageupload_fullsize_width);
					$newimage->jpeg_quality(module_imageupload_jpg_quality);
					$newimage->save($destPath.$destFile, module_imageupload_gdversion);
				}
				break;
			case "h":
				if ($thisImageHeight > module_imageupload_fullsize_height)
				{
					$newimage = new thumbnail($destPath.$destFile);
					$newimage->size_auto(module_imageupload_fullsize_height);
					$newimage->jpeg_quality(module_imageupload_jpg_quality);
					$newimage->save($destPath.$destFile, module_imageupload_gdversion);
				}
				break;
		}			
	}
	
	// If no errors, then let's update the database
	if (!$module_error)
	{
		$destFile .= ".jpg";
		
		$db->query("UPDATE ".table_links." set ".module_imageupload_filename_field."='$destFile' WHERE link_id='$linkID'");
	}
}

function image_upload_preview_handler()
{
	global $db, $smarty, $main_smarty;

	include_once('image_upload_settings.php');
	$smarty->plugins_dir[] = image_upload_plugins_path;

	// Get the page we are on
	$pagename = $main_smarty->get_template_vars('pagename');

	// Otherwise, let's get it from the Submission field its saved in
	$imageFile = $smarty->get_template_vars(module_imageupload_filename_field);
	
	$imagePath = module_imageupload_basedir.module_imageupload_imagedir;
	
	if (module_imageupload_debugmode)
	{
		echo "Preview process...<br/>";
		echo "Image Path = ".$imagePath.$imageFile."<br/>";
	}
	
	// Let's be sure the file exists and hasn't been deleted for some reason
	if ($imageFile != "")
	{
		if (file_exists($imagePath.$imageFile))
		{
		
			echo module_imageupload_img_css_pre;
			
			if (module_imageupload_use_thumb)
			{
				if (module_imageupload_use_thickbox)
				{
					// User Thickbox method
					echo module_imageupload_thickbox_pre1 . $imageFile . module_imageupload_thickbox_pre2. module_imageupload_preview_pre . module_imageupload_thumb_generator . module_imageupload_thumb_generator_pre . $imageFile . module_imageupload_thumb_generator_post . module_imageupload_preview_post . module_imageupload_thickbox_post;
					echo module_imageupload_legendtext;
				} else {
					// User Thickbox method
					echo module_imageupload_directlink_pre1 . $imageFile . module_imageupload_directlink_pre2. module_imageupload_preview_pre . module_imageupload_thumb_generator . module_imageupload_thumb_generator_pre . $imageFile . module_imageupload_thumb_generator_post . module_imageupload_preview_post . module_imageupload_directlink_post;
					echo module_imageupload_legendtext;
				}
			} else {
				// Just show the fullsize image
				echo module_imageupload_preview_pre.module_imageupload_imagedir.$imageFile.module_imageupload_preview_post;
			}
			
			echo module_imageupload_img_css_post;
		}
	}
}

function image_upload_cleanup()
{
	global $db, $smarty, $image;

	@unlink(module_imageupload_basedir."/".module_imageupload_imagedir.$_SESSION['module_imageupload_filename']);
	unset($_SESSION['module_imageupload_filename']);
}

function image_upload_fullsize_handler()
{
	global $db, $smarty, $image;

	include_once('image_upload_settings.php');
	$smarty->plugins_dir[] = image_upload_plugins_path;

	echo "Image fullsize process<br/>";
}

function image_upload_delete_handler()
{
	global $db, $smarty, $image;

	include_once('image_upload_settings.php');
	$smarty->plugins_dir[] = image_upload_plugins_path;

	echo "Image delete process<br/>";
}

?>